import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(14, 4))

# Define colors for statuses
colors = {
    'clear': 'green',
    'not clear': 'red'
}

# Define curbs and cars
curbs = [
    {'id': 'curb_0', 'cars': [('car6', 'not clear'), ('car7', 'clear')]},
    {'id': 'curb_1', 'cars': [('car1', 'not clear'), ('car8', 'clear')]},
    {'id': 'curb_2', 'cars': [('car9', 'not clear'), ('car4', 'clear')]},
    {'id': 'curb_3', 'cars': [('car3', 'clear')]},
    {'id': 'curb_4', 'cars': [('car0', 'clear')]},
    {'id': 'curb_5', 'cars': [('car5', 'clear')]},
    {'id': 'curb_6', 'cars': [('car2', 'clear')]}
]

# Draw curbs and cars
for idx, curb in enumerate(curbs):
    # Draw curb
    curb_rect = patches.Rectangle((idx * 2, 0), 1.5, 1, edgecolor='black', facecolor='lightgrey')
    ax.add_patch(curb_rect)
    ax.text(idx * 2 + 0.75, 1.1, curb['id'], ha='center', va='bottom', fontsize=9, fontweight='bold')
    
    # Draw cars
    for car_idx, (car_id, status) in enumerate(curb['cars']):
        car_circle = patches.Circle((idx * 2 + 0.75, 0.5 - car_idx * 0.4), 0.2, edgecolor='black', facecolor=colors[status])
        ax.add_patch(car_circle)
        ax.text(idx * 2 + 0.75, 0.5 - car_idx * 0.4, car_id, ha='center', va='center', fontsize=8, color='white' if status == 'not clear' else 'black')
        ax.text(idx * 2 + 0.75, 0.5 - car_idx * 0.4 - 0.25, status, ha='center', va='center', fontsize=7, color='white' if status == 'not clear' else 'black')

# Add legend
legend_elements = [
    patches.Patch(facecolor='green', edgecolor='black', label='Clear'),
    patches.Patch(facecolor='red', edgecolor='black', label='Not Clear')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=9)

# Set limits and hide axes
ax.set_xlim(-0.5, len(curbs) * 2)
ax.set_ylim(-0.5, 1.5)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_33.png', bbox_inches='tight')
plt.show()